IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_LGPD_PROCESSAMENTO_FUNC')
BEGIN 
	DROP PROCEDURE P_LGPD_PROCESSAMENTO_FUNC
END 

GO 
/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 21100101
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_FUNC 
'Objetivo............: Procedure responsavel pela anonimização de Funcionarios - LGPD 
'Tabelas.............: FP_FUNC, LGPD_LOG_PROCESSAMENTO
'Dt Criação..........: 
'Dt Ult Alteracão....: 01/10/2021
'Alterado por........: Marcos barros
'Criado por..........: Rayane
'=======================================================================================
Reg #21081901 - Alteração retorno RAISERROR  - Marcos Barros
Reg #21081901 - Alteração estrutura de insert em @NAO_ANONIMIZAR_DADOS - Marcos Barros
Reg #21100101 - Alteração tipo de dados retornado por parametro - Marcos Barros
*/

CREATE PROCEDURE P_LGPD_PROCESSAMENTO_FUNC (@CD_FUN INT )
WITH ENCRYPTION
AS 
 
	SET NOCOUNT ON 
	declare @DtIni date, @DtFim date
	DECLARE @NAO_ANONIMIZAR_DADOS TABLE  ( CD_FUN INT, DESCRICAO VARCHAR(1000) );
	
	Set @DtIni = dateadd(year,-5,getdate())
	Set @DtFim = getdate();


	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT  
		CD_FUN,
		('NÃO PODE SER ANONIMIZADO: FUNCIONARIO ' + CAST(@CD_FUN AS VARCHAR) +', POSSUI VALE EM ABERTO')
	FROM UFD_FP_FUNC_EXTRATO_VALE(1, @DtIni, @DtFim)
		WHERE VLR_VALE  <> 0
		AND TP_TRANSA <> 2
		AND CD_FUN = @CD_FUN
	    
	IF EXISTS (SELECT 1 FROM @NAO_ANONIMIZAR_DADOS  )
	BEGIN 
		DECLARE @ERRORMESSAGE VARCHAR(MAX)= (SELECT DESCRICAO FROM ( SELECT T.DESCRICAO, ROW_NUMBER() OVER(ORDER BY CD_FUN DESC) AS RowNumber FROM @NAO_ANONIMIZAR_DADOS T WHERE CD_FUN = @CD_FUN ) AS tmp WHERE RowNumber = 1);
		RAISERROR (@ERRORMESSAGE, 16, 1);
		RETURN;
	END
	
/* ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/	
  
	PRINT 'ANONIMIZANDO FUNCIONARIO';
		UPDATE FP_FUNC 
			SET	 NM_FUN	  ='ANONIMIZADO'
				,CPF_FUN  ='000000000000'
				,RG_FUN	  ='000000000000'
				,TIT_ELEI ='000000000000'
				,DT_NASC  ='19000101'
				,TEL_FUN  ='0000000000'
				,END_FUN  ='ANONIMIZADO'
				,PRI_NM	  ='ANONIMIZADO'
				,TEL_RES  ='0000000000'
				,TEL_CEL  ='0000000000'
				,EMAIL	  ='ANONIMIZADO@ANONIMIZADO'
				,NR_END	  ='ANONIMIZADO'
				,PONTO_REF='ANONIMIZADO'
			WHERE CD_FUN = @CD_FUN
				  

	INSERT INTO LGPD_LOG_PROCESSAMENTO  (CD_PESSOA,DT_CAD,NM_FM,TP_PROC)
	SELECT @CD_FUN					AS CD_CLI, 
			GETDATE()				AS DT_CAD,
			'P_LGPD_PROCESSAMENTO_FUNC'	AS NM_FM,
			3						AS TP_PROC
 
